package gov.va.med.mhv.mrp.data.model;

import java.io.Serializable;
import javax.persistence.*;

import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name="MYGOALS_EXTENSIONS")
@NamedQuery(name="MyGoalsExtensions.findAll", query="SELECT m FROM MyGoalsExtensions m order by m.goalExtensionSequenceNumber")
public class MyGoalsExtensions implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue(strategy=GenerationType.AUTO)
	@Column(name="GOAL_EXTENSION_ID")
	private Long goalExtensionId;

	private String description;

	@Column(name="GOAL_EXTENSION_SEQUENCE_NUMBER")
	private Integer goalExtensionSequenceNumber;

	@Column(name="GOAL_EXTENSION_TYPE")
	private Integer goalExtensionType;

	@Version
	private Integer oplock;

	//bi-directional many-to-one association to MyGoals
	@ManyToOne
	@JoinColumn(name="GOAL_ID")
	private MyGoals myGoal;

	//bi-directional many-to-one association to MyGoalsTasks
	@OneToMany(mappedBy="myGoalsExtension", cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true)
	private List<MyGoalsTasks> myGoalsTasks = new ArrayList<MyGoalsTasks>();;

	public MyGoalsExtensions() {
	}

	public Long getGoalExtensionId() {
		return this.goalExtensionId;
	}

	public void setGoalExtensionId(Long goalExtensionId) {
		this.goalExtensionId = goalExtensionId;
	}

	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Integer getGoalExtensionSequenceNumber() {
		return this.goalExtensionSequenceNumber;
	}

	public void setGoalExtensionSequenceNumber(Integer goalExtensionSequenceNumber) {
		this.goalExtensionSequenceNumber = goalExtensionSequenceNumber;
	}

	public Integer getGoalExtensionType() {
		return this.goalExtensionType;
	}

	public void setGoalExtensionType(Integer goalExtensionType) {
		this.goalExtensionType = goalExtensionType;
	}

	public Integer getOplock() {
		return this.oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public MyGoals getMyGoal() {
		return this.myGoal;
	}

	public void setMyGoal(MyGoals myGoal) {
		this.myGoal = myGoal;
	}

	public List<MyGoalsTasks> getMyGoalsTasks() {
		return this.myGoalsTasks;
	}

	public void setMyGoalsTasks(List<MyGoalsTasks> myGoalsTasks) {
		this.myGoalsTasks = myGoalsTasks;
	}

	public MyGoalsTasks addMyGoalsTask(MyGoalsTasks myGoalsTask) {
		getMyGoalsTasks().add(myGoalsTask);
		myGoalsTask.setMyGoalsExtension(this);

		return myGoalsTask;
	}

	public MyGoalsTasks removeMyGoalsTask(MyGoalsTasks myGoalsTask) {
		getMyGoalsTasks().remove(myGoalsTask);
		myGoalsTask.setMyGoalsExtension(null);

		return myGoalsTask;
	}

}